///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _EVENTLOG_H
#define _EVENTLOG_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _SQLESERVER
	#ifdef _EVENT_LOG_BUILD
	#include "../SQLEServer/Source/Routines.h"
	#include "../SQLEServer/Source/Entry.h"
	#include "EventMsg/EventMsg.h"
	#else
	#include "EventMsg/EventMsg.h"
	#endif
#elif _SQLECLIENT
	#ifdef _EVENT_LOG_BUILD
	#include "../SQLEClient/Source/Routines.h"
	#include "../SQLEClient/Source/Entry.h"
	#include "EventMsg/EventMsg.h"
	#else
	#include "EventMsg/EventMsg.h"
	#endif
#else
	#error "You must define either _SQLESERVER or _SQLECLIENT"
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool RecordWarn(const char *sMsg);
bool RecordError(const char *sMsg);
bool RecordInfo(const char *sMsg);
bool RecordEvent(WORD dwEventType, DWORD dwEventID, WORD wCategory, const char *sMsg);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
